#!/bin/bash
#SBATCH --mem=5G
#SBATCH --cpus-per-task=2
#SBATCH --time=12:00:00
#SBATCH --output=/scratch/shared/beegfs/yuki/fast/slurm/face/IN1k-%a.out
#SBATCH --partition=compute
#SBACTH --open-mode=append
#SBATCH --job-name=facedet
#SBATCH --array=0-17

echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*80000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*80000))

in_file=_tmp_in1ktrain_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/in1k/face/'
mkdir -p ${results_dir}

< /users/yuki/adiwol/IN1k_train.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

echo "from " ${X}
echo "to " ${Y}

# ETA 4-6Hz
/scratch/shared/beegfs/yuki/envs/py37/bin/python3 -W ignore main_face_detector.py \
  --input_txt=${in_file} \
  --save_folder=${results_dir} \
  --cpu